<?php
/**
 * Handles CSV export for Audit Trail plugin.
 * Compatible with PHP 8.2.12 and above
 */

if (!defined('ABSPATH')) {
    exit;
}

class Audit_Export {

    public static function init() {
        add_action('admin_init', [__CLASS__, 'maybe_export_csv']);
    }

    public static function maybe_export_csv() {
        if (!isset($_GET['at_export']) || !current_user_can('read')) {
            return;
        }

        $user_id = get_current_user_id();
        $type = sanitize_text_field($_GET['at_export']); // 'login' or 'activity'

        global $wpdb;
        $filename = 'audit-trail-' . $type . '-' . date('Y-m-d') . '.csv';

        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Pragma: no-cache');
        header('Expires: 0');

        $output = fopen('php://output', 'w');

        if ($type === 'login') {
            fputcsv($output, ['Sr No', 'User ID', 'User Name', 'IP Address', 'Browser', 'Login Date and Time', 'Logout Date and Time', 'Status', 'Message']);
            $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}at_login_history WHERE user_id = %d ORDER BY login_time DESC", $user_id));
            $sr = 1;
            foreach ($rows as $row) {
                fputcsv($output, [
                    $sr++,
                    $row->user_id,
                    $row->user_login,
                    $row->ip_address,
                    $row->browser,
                    $row->login_time,
                    $row->logout_time,
                    $row->status,
                    $row->message
                ]);
            }

        } elseif ($type === 'activity') {
            fputcsv($output, ['Sr No', 'ID', 'User ID', 'User Role', 'Date and Time', 'Activity', 'Type', 'Description']);
            $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}at_user_activities WHERE user_id = %d ORDER BY datetime DESC", $user_id));
            $sr = 1;
            foreach ($rows as $row) {
                fputcsv($output, [
                    $sr++,
                    $row->id,
                    $row->user_id,
                    $row->user_role,
                    $row->datetime,
                    $row->activity,
                    $row->type,
                    $row->description
                ]);
            }
        }

        fclose($output);
        exit;
    }
}

Audit_Export::init();
